 ; DH - Data Highway Plus line drawer - requires the block DH.
 ; Copyright 1991, 1996, 1998, 2010 by Rocket Software Ltd.
 ; Apparently people from Ontario use a lot of this stuff.
 (DEFUN C:DH ( / xa dd radx lenx gax rotx xa2 xa1 xa3
                              xah angl angg num remn n1 totl)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
  (setq dimsc (misps))
  (if (= xb ())
      (setq xa (getpoint "Start point?\n"))
      (progn
           (setq xa (getpoint "New start or <Return> to continue:\n"))
           (if (= xa ()) (setq xa xb))))
  (setq xb (getpoint xa "And end?\n"))
  (setq radi dimsc)                        ; block scale
  (setq len (* 15 dimsc))                  ; line length
  (setq gap (* 3.5 dimsc))                 ; block space
  (setq rota "N")                          ; don't rotate block to match line
  (setq totl (+ len gap))
  (setq dd (distance xa xb))               ; total length
  (setq num (fix (/ dd totl)))             ; # of segments
  (setq n1 0)                              ; draw counter
  (setq remn (/ (- (rem dd totl) gap) 2))  ; end lengths
  (setq angg (angle xa xb))
  (if (= rota "Y")
      (setq angl (* 360 (/ angg (* 2 pi))))
      (setq angl 0))
  (if (< remn (/ gap 2))
      (setq num (1- (fix (/ dd totl)))               ; # of segments
            remn (/ (- dd (* num totl) gap) 2)))
  (if (> dd totl)
      (progn
            (setq xa2 (polar xa angg remn))          ; 1st segment
            (command "line" xa xa2 "")
            (command "insert" "dh" (polar xa2 angg (/ gap 2)) radi "" angl)
            (setq xa (polar xa2 angg gap))           ; gap
            (while (< n1 num)                        ; draw segments:
                   (setq xa1 (polar xa angg len))
                   (command "line" xa xa1 "")
                   (command "insert" "dh" (polar xa1 angg 
                                                     (/ gap 2)) radi "" angl)
                   (setq xa (polar xa1 angg gap))    ; gap
                   (setq n1 (1+ n1)))
            (command "line" xa xb "")
            (write-line (strcat "Segments drawn: " (itoa (1+ num)))))
      (if (> dd (* 1.5 gap))
          (progn 
          (command "line" xa (setq xah (polar xa angg (/ (- dd gap) 2))) "")
          (command "insert" "dh" (polar xah angg (/ gap 2)) radi "" angl)
          (setq xa (polar xah angg gap))
          (command "line" xa xb "")
          (write-line "1 segment squashed in."))
          (Progn
                (command "line" xa xb "")
                (write-line "Sorry, no room for details."))))
 (princ))
